/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.UserUtils;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class HMCUserCreate
implements HMCCommands {
    private String userName;
    private String fullName;
    private String role;
    private String newPassword;
    private String retypePassword;
    private String deleteCommand = null;
    private Integer passwdDays;

    public void deleteUser() {
        if (this.deleteCommand != null) {
            EExecResult eExecResult = EExec.Exec((String)this.deleteCommand);
        }
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        Object[] objectArray;
        Object object;
        int n;
        String string;
        String string2;
        String string3;
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "CREATE";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        Hashtable hashtable = new Hashtable();
        String[] stringArray = null;
        String[] stringArray2 = new String[1];
        String string11 = System.getProperty("HMCRealUser.name");
        String[] stringArray3 = new String[2];
        stringArray3[0] = this.userName;
        stringArray2[0] = UserUtils.getRoleDescription(this.role);
        if (stringArray2[0] == null) {
            Object[] objectArray2 = new String[]{HMCCommandUtils.ADD_ACCESS_PARAM, "op, advop, sysadmin, usradmin, svcrep, viewer"};
            string4 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", null, objectArray2);
            throw new RequiredParameterException(string4);
        }
        stringArray3[1] = stringArray2[0];
        if (!UserUtils.isInputValid(string7, this.userName, this.fullName, stringArray2, string8, string9, stringArray, string10, hashtable)) {
            string5 = (String)hashtable.get("errorException");
            string4 = string5 != null ? HSCResourceBundleUtil.getMessage("HSCExceptionBundle", string5) : (String)hashtable.get("errorText");
            throw new HSCException(string4);
        }
        string6 = (String)hashtable.get("cmd");
        EExecResult eExecResult = EExec.Exec((String)string6);
        if (eExecResult.rc != 0) {
            String string12 = "HSCE2102 User name " + string11 + ": Failed to create user " + stringArray3[0] + " with role " + stringArray3[1];
            HSCLogUtils.logSystemEvent((short)2102, string12, stringArray3, string11);
            Object[] objectArray3 = new String[]{this.userName};
            string4 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ERROR_CREATING_USER", null, objectArray3);
            throw new HSCException(string4);
        }
        String string13 = (String)hashtable.get("roles_PROP");
        this.deleteCommand = string13.equals("HSC_Admin") ? "/opt/hsc/bin/HSCUserConf -d " + this.userName + " -rmcnothing" : "/opt/hsc/bin/HSCUserConf -d " + this.userName + " -rmcdelete";
        try {
            string3 = System.getProperty("HMCtty.name");
            string2 = null;
            string = null;
            n = 0;
            if (string3 != null && string3 != "") {
                eExecResult = EExec.Exec((String)("stty --save --file=" + string3));
                string2 = "stty --file=" + string3 + " " + eExecResult.stdout;
                string = "stty --file=" + string3 + " -echo";
                n = 1;
            }
            object = new String[]{this.userName};
            objectArray = new BufferedReader(new InputStreamReader(System.in));
            System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ENTER_NEW_PASSWORD", null, object));
            if (n != 0) {
                eExecResult = EExec.Exec(string);
            }
            this.newPassword = objectArray.readLine().trim();
            if (n != 0) {
                eExecResult = EExec.Exec((String)string2);
            }
            System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ENTER_CONFIRM_PASSWORD", null, object));
            if (n != 0) {
                eExecResult = EExec.Exec((String)string);
            }
            this.retypePassword = objectArray.readLine().trim();
            if (n != 0) {
                eExecResult = EExec.Exec((String)string2);
            }
            objectArray.close();
        }
        catch (IOException iOException) {
            string4 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ERROR_READING_PASSWORD");
            throw new HSCException(string4);
        }
        hashtable.clear();
        string3 = "CREATE_USER";
        string2 = null;
        string = System.getProperty("user.name");
        if (!UserUtils.isPasswordInputValid(string3, this.userName, this.newPassword, this.retypePassword, string2, string, hashtable)) {
            string5 = (String)hashtable.get("errorException");
            string4 = string5 != null ? HSCResourceBundleUtil.getMessage("HSCExceptionBundle", string5) : (String)hashtable.get("errorText");
            throw new HSCException(string4);
        }
        string6 = (String)hashtable.get("cmd1");
        eExecResult = EExec.Exec((String)string6);
        n = eExecResult.rc;
        if (eExecResult.rc == 0) {
            string6 = (String)hashtable.get("cmd2");
            if (string6 != null) {
                eExecResult = EExec.Exec((String)string6);
            }
        } else {
            object = "HSCE2102 User name " + string11 + ": Failed to create user " + stringArray3[0] + " with role " + stringArray3[1];
            HSCLogUtils.logSystemEvent((short)2102, (String)object, stringArray3, string11);
            if (n == 1) {
                string4 = HSCResourceBundleUtil.getMessage("UserBundle", "PASSWORD_ERROR", "BAD PASSWORD: it is too simplistic/systematic");
                throw new HSCException(string4);
            }
            if (n > 1) {
                objectArray = new String[]{this.userName};
                string4 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ERROR_SETTING_PASSWORD", null, objectArray);
                throw new HSCException(string4);
            }
            return;
        }
        if (this.passwdDays != null) {
            eExecResult = EExec.Exec((String)("/opt/hsc/bin/HSCUserConf -x -M " + this.passwdDays.toString() + " " + this.userName));
            if (eExecResult.rc != 0) {
                string4 = HSCResourceBundleUtil.getMessage("UserBundle", "PASSWORD_AGE_SETTING_ERROR", "Unable to set password expiration days.");
                throw new HSCException(string4);
            }
            return;
        }
        object = "HSCE2101 User name " + string11 + ": Created user " + stringArray3[0] + " with role " + stringArray3[1];
        HSCLogUtils.logSystemEvent((short)2101, (String)object, stringArray3, string11);
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        String string = null;
        int n = 0;
        this.userName = (String)hashMap.get(HMCCommandUtils.USER_NAME_PARAM);
        if (this.userName != null) {
            this.userName = this.userName.trim();
        }
        this.role = (String)hashMap.get(HMCCommandUtils.ADD_ACCESS_PARAM);
        if (this.role != null) {
            this.role = this.role.trim();
        }
        if (this.userName == null || this.role == null) {
            Object[] objectArray = new String[]{HMCCommandUtils.USER_NAME_PARAM + ", " + HMCCommandUtils.ADD_ACCESS_PARAM};
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray);
            throw new RequiredParameterException(string);
        }
        n = 2;
        this.fullName = (String)hashMap.get(HMCCommandUtils.DESCRIPTION_PARAM);
        if (this.fullName != null) {
            this.fullName = this.fullName.trim();
            ++n;
        } else {
            this.fullName = "";
        }
        String string2 = (String)hashMap.get(HMCCommandUtils.MAX_PASSWORD_DAYS);
        if (string2 != null) {
            try {
                this.passwdDays = new Integer(string2);
                ++n;
            }
            catch (Exception exception) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "INVALID_INT_VALUE", "Invalid int value.");
                throw new RequiredParameterException(string);
            }
        }
        HMCCommandUtils.checkParameterCount(hashMap, n);
    }

    public void printResults() {
    }

    public void printHelp() {
        System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "HMCUSER_CREATE_HELP"));
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        HMCUserCreate hMCUserCreate = new HMCUserCreate();
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                hMCUserCreate.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    hMCUserCreate.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                hMCUserCreate.mapParameters(hashMap);
                hMCUserCreate.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (IDebug.enabled()) {
                hSCException.printStackTrace();
            }
            hMCUserCreate.deleteUser();
            string = hSCException.getMessage();
            if (string == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            hMCUserCreate.deleteUser();
            string = requiredParameterException.getMessage();
            if (string == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            hMCUserCreate.deleteUser();
            System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            System.exit(1);
        }
        System.exit(0);
    }
}

